# Breaker Cross Reference (Self-hosted, cPanel)

Install path: **489.rona.plus/breakers**

This app replaces Airtable/Softr with a simple **PHP + MySQL** lookup tool, plus an **admin area** for edits and batch updates.

---

## 1) Upload files (cPanel)
1. Download the zip from ChatGPT.
2. In cPanel **File Manager**, go to your site root (usually `public_html/`).
3. Upload and extract the zip.
4. You should end up with: `public_html/breakers/`

---

## 2) Create database (cPanel)
1. cPanel → **MySQL Databases**
2. Create:
   - database: `YOUR_DB_NAME`
   - user: `YOUR_DB_USER`
   - password: `YOUR_DB_PASSWORD`
3. Add the user to the database with **ALL PRIVILEGES**.

---

## 3) Create the table (phpMyAdmin)
1. cPanel → **phpMyAdmin**
2. Select your database
3. Click **SQL**
4. Paste contents of `install.sql` and run it.

---

## 4) Configure DB + Admin password
Edit:

### `breakers/inc/db.php`
Set:
- DB_NAME
- DB_USER
- DB_PASS

### `breakers/inc/auth.php`
Set:
- ADMIN_USER
- ADMIN_PASS

**Tip:** also protect `/breakers/admin` using cPanel **Directory Privacy** for extra security.

---

## 5) Import your first CSV
1. Go to: `https://489.rona.plus/breakers/admin/`
2. Login
3. Click **Batch Import**
4. Upload your CSV

### Image links from Airtable
If the CSV includes temporary Airtable attachment URLs, the importer will try to:
- download each image once
- save it to `/breakers/uploads/`
- store the local `uploads/...` path in the database

If an image URL is already expired when you import, it will fail (and that row will show "No image" until you upload one manually or re-import with a valid URL).

---

## 6) Updating content (two ways)
### A) Quick edits / add one
Admin → **Add New** or **Edit** any row.

Includes a **Delete Row** button (per-row) if you truly want it removed.

### B) Batch update
Admin → **Batch Import**
- Update/Add only (does NOT delete)
- Use **Export CSV** to grab the current live dataset, edit in Excel/Google Sheets, then re-import.

---

## 7) Stock checking (Winnipeg stores)
The public tool includes a **Check stock (Winnipeg)** button per product.
It checks 3 stores:
- 64890 Winnipeg Central
- 83285 Winnipeg South
- 83718 Winnipeg East

Results are cached for ~1 hour in `/breakers/cache/` to reduce load.

---

## Troubleshooting
- Blank page: check PHP version (8+ recommended) and enable error logging.
- “DB connection failed”: verify credentials in `inc/db.php` and that the user has privileges.
- Import images failing: temporary Airtable links may be expired; re-export from Airtable or upload images manually in Edit.

