<?php
// expects: $row (array), $isNew (bool)
?>
<div class="row g-2">
  <div class="col-6 col-md-2">
    <label class="form-label">Bin Number *</label>
    <input class="form-control" name="bin_number" required value="<?= h($row['bin_number'] ?? '') ?>">
  </div>
  <div class="col-6 col-md-2">
    <label class="form-label">SKU</label>
    <input class="form-control" name="sku" value="<?= h($row['sku'] ?? '') ?>">
  </div>
  <div class="col-12 col-md-3">
    <label class="form-label">Friendly SKU</label>
    <input class="form-control" name="friendly_sku" value="<?= h($row['friendly_sku'] ?? '') ?>">
  </div>
  <div class="col-12 col-md-5">
    <label class="form-label">Brand *</label>
    <input class="form-control" name="brand" required value="<?= h($row['brand'] ?? '') ?>">
  </div>

  <div class="col-6 col-md-2">
    <label class="form-label">Amperage</label>
    <input class="form-control" name="amperage" value="<?= h($row['amperage'] ?? '') ?>">
  </div>
  <div class="col-6 col-md-3">
    <label class="form-label">Poles</label>
    <input class="form-control" name="poles" value="<?= h($row['poles'] ?? '') ?>">
  </div>
  <div class="col-12 col-md-3">
    <label class="form-label">Safety Features</label>
    <input class="form-control" name="safety_features" value="<?= h($row['safety_features'] ?? '') ?>" placeholder="e.g. GFCI or AFCI or GFCI,AFCI">
  </div>
  <div class="col-12 col-md-4">
    <label class="form-label">Mounting</label>
    <input class="form-control" name="mounting" value="<?= h($row['mounting'] ?? '') ?>">
  </div>

  <div class="col-12">
    <label class="form-label">Product Link (RONA)</label>
    <input class="form-control" name="product_link" value="<?= h($row['product_link'] ?? '') ?>">
  </div>

  <div class="col-12 col-md-7">
    <label class="form-label">Image</label>
    <div class="input-group">
      <input class="form-control" name="image_path" value="<?= h($row['image_path'] ?? '') ?>" placeholder="uploads/your-image.png">
      <span class="input-group-text">or upload ↓</span>
      <input class="form-control" type="file" name="image_upload" accept="image/*">
    </div>
    <div class="form-text">If you upload, it will be saved to /breakers/uploads/ and overwrite Image Path.</div>
  </div>

  <div class="col-12 col-md-5">
    <label class="form-label">Status</label>
    <select class="form-select" name="is_active">
      <option value="1" <?= ((int)($row['is_active'] ?? 1)===1)?'selected':'' ?>>Active</option>
      <option value="0" <?= ((int)($row['is_active'] ?? 1)===0)?'selected':'' ?>>Inactive</option>
    </select>
  </div>
</div>
