<?php
declare(strict_types=1);
require_once __DIR__ . '/../inc/auth.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/util.php';
require_admin();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { header('Location: /breakers/admin/list.php'); exit; }

$pdo = db();
$st = $pdo->prepare("SELECT * FROM breakers WHERE id = :id");
$st->execute([':id' => $id]);
$row = $st->fetch();
if (!$row) { header('Location: /breakers/admin/list.php'); exit; }

$error = '';
$success = '';

function save_upload(?array $file): ?string {
  if (!$file || empty($file['tmp_name']) || !is_uploaded_file($file['tmp_name'])) return null;
  $name = basename((string)$file['name']);
  $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
  if (!in_array($ext, ['png','jpg','jpeg','webp','gif'], true)) return null;

  $safeBase = preg_replace('/[^a-zA-Z0-9_\-\.]+/', '_', pathinfo($name, PATHINFO_FILENAME));
  $final = $safeBase . '_' . date('Ymd_His') . '.' . $ext;

  $destRel = 'uploads/' . $final;
  $destAbs = realpath(__DIR__ . '/..') . '/' . $destRel;

  if (@move_uploaded_file($file['tmp_name'], $destAbs)) return $destRel;
  return null;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_check((string)($_POST['csrf'] ?? ''))) {
    http_response_code(400);
    die('Bad CSRF token');
  }

  if (isset($_POST['delete']) && $_POST['delete'] === '1') {
    $pdo->prepare("DELETE FROM breakers WHERE id = :id")->execute([':id' => $id]);
    header('Location: /breakers/admin/list.php');
    exit;
  }

  $row = [
    'bin_number' => q($_POST['bin_number'] ?? ''),
    'sku' => q($_POST['sku'] ?? '') ?: null,
    'friendly_sku' => q($_POST['friendly_sku'] ?? '') ?: null,
    'brand' => q($_POST['brand'] ?? ''),
    'amperage' => q($_POST['amperage'] ?? '') ?: null,
    'poles' => q($_POST['poles'] ?? '') ?: null,
    'safety_features' => q($_POST['safety_features'] ?? '') ?: null,
    'mounting' => q($_POST['mounting'] ?? '') ?: null,
    'product_link' => q($_POST['product_link'] ?? '') ?: null,
    'image_path' => q($_POST['image_path'] ?? '') ?: null,
    'is_active' => (int)($_POST['is_active'] ?? 1),
  ];

  $up = save_upload($_FILES['image_upload'] ?? null);
  if ($up) $row['image_path'] = $up;

  if ($row['bin_number'] === '' || $row['brand'] === '') {
    $error = 'Bin Number and Brand are required.';
  } else {
    $sql = "UPDATE breakers SET
              bin_number=:bin, sku=:sku, friendly_sku=:fsku, brand=:brand, amperage=:amp, poles=:poles,
              safety_features=:safety, mounting=:mount, image_path=:img, product_link=:link, is_active=:active
            WHERE id=:id";
    $st2 = $pdo->prepare($sql);
    $st2->execute([
      ':bin' => $row['bin_number'],
      ':sku' => $row['sku'],
      ':fsku' => $row['friendly_sku'],
      ':brand' => $row['brand'],
      ':amp' => $row['amperage'],
      ':poles' => $row['poles'],
      ':safety' => $row['safety_features'],
      ':mount' => $row['mounting'],
      ':img' => $row['image_path'],
      ':link' => $row['product_link'],
      ':active' => $row['is_active'] ? 1 : 0,
      ':id' => $id,
    ]);
    $success = 'Saved.';
  }

  // Refresh from DB
  $st = $pdo->prepare("SELECT * FROM breakers WHERE id = :id");
  $st->execute([':id' => $id]);
  $row = $st->fetch();
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Edit Breaker</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container py-4" style="max-width: 1000px;">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h1 class="h4 m-0">Edit Breaker #<?= (int)$id ?></h1>
      <a class="btn btn-outline-secondary btn-sm" href="/breakers/admin/list.php">Back</a>
    </div>

    <?php if ($error): ?>
      <div class="alert alert-danger"><?= h($error) ?></div>
    <?php elseif ($success): ?>
      <div class="alert alert-success"><?= h($success) ?></div>
    <?php endif; ?>

    <form class="card shadow-sm mb-3" method="post" enctype="multipart/form-data">
      <div class="card-body">
        <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
        <?php $isNew = false; include __DIR__ . '/_form.php'; ?>
      </div>
      <div class="card-footer d-flex justify-content-between">
        <div class="d-flex gap-2">
          <a class="btn btn-outline-secondary" target="_blank" rel="noopener" href="/breakers/">Open tool</a>
          <?php if (!empty($row['product_link'])): ?>
            <a class="btn btn-outline-primary" target="_blank" rel="noopener" href="<?= h($row['product_link']) ?>">Open product</a>
          <?php endif; ?>
        </div>
        <div class="d-flex gap-2">
          <button class="btn btn-primary" type="submit">Save</button>
        </div>
      </div>
    </form>

    <form method="post" onsubmit="return confirm('Delete this row permanently? This cannot be undone.');">
      <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
      <input type="hidden" name="delete" value="1">
      <button class="btn btn-danger">Delete Row</button>
    </form>
  </div>
</body>
</html>
