<?php
declare(strict_types=1);
require_once __DIR__ . '/../inc/auth.php';
require_once __DIR__ . '/../inc/db.php';
require_admin();

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="breakers_export.csv"');

$out = fopen('php://output', 'w');
fputcsv($out, ['Bin Number','SKU','Friendly SKU','Brand','Amperage','Poles','Safety Features','Mounting','Image','Link','Active']);

$sql = "SELECT bin_number, sku, friendly_sku, brand, amperage, poles, safety_features, mounting, image_path, product_link, is_active
        FROM breakers
        ORDER BY brand ASC, amperage+0 ASC, poles ASC, safety_features ASC, bin_number+0 ASC";
$st = db()->query($sql);

while ($r = $st->fetch()) {
  fputcsv($out, [
    $r['bin_number'],
    $r['sku'],
    $r['friendly_sku'],
    $r['brand'],
    $r['amperage'],
    $r['poles'],
    $r['safety_features'],
    $r['mounting'],
    $r['image_path'], // local path (uploads/...)
    $r['product_link'],
    $r['is_active'] ? '1' : '0',
  ]);
}
fclose($out);
exit;
