<?php
declare(strict_types=1);
require_once __DIR__ . '/../inc/auth.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/util.php';
require_admin();

$pdo = db();

$q = trim((string)($_GET['q'] ?? ''));
$active = trim((string)($_GET['active'] ?? '1')); // 1 or 0 or all

$conds = [];
$params = [];

if ($q !== '') {
  $conds[] = "(bin_number LIKE :q OR sku LIKE :q OR friendly_sku LIKE :q OR brand LIKE :q OR product_link LIKE :q)";
  $params[':q'] = '%' . $q . '%';
}
if ($active === '1') $conds[] = "is_active = 1";
if ($active === '0') $conds[] = "is_active = 0";

$where = $conds ? ("WHERE " . implode(" AND ", $conds)) : "";

$sql = "SELECT id, bin_number, sku, friendly_sku, brand, amperage, poles, safety_features, mounting, is_active, updated_at
        FROM breakers
        $where
        ORDER BY updated_at DESC
        LIMIT 250";
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin - Breakers</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container py-4" style="max-width: 1300px;">
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 mb-3">
      <h1 class="h4 m-0">Breaker Admin</h1>
      <div class="d-flex gap-2">
        <a class="btn btn-outline-secondary btn-sm" href="/breakers/">View Tool</a>
        <a class="btn btn-outline-secondary btn-sm" href="/breakers/admin/export.php">Export CSV</a>
        <a class="btn btn-outline-primary btn-sm" href="/breakers/admin/import.php">Batch Import</a>
        <a class="btn btn-primary btn-sm" href="/breakers/admin/new.php">Add New</a>
        <a class="btn btn-outline-danger btn-sm" href="/breakers/admin/logout.php">Logout</a>
      </div>
    </div>

    <div class="card shadow-sm mb-3">
      <div class="card-body">
        <form class="row g-2 align-items-end" method="get">
          <div class="col-12 col-md-6">
            <label class="form-label">Search</label>
            <input class="form-control" name="q" value="<?= h($q) ?>" placeholder="bin / sku / friendly / brand / url">
          </div>
          <div class="col-6 col-md-2">
            <label class="form-label">Status</label>
            <select class="form-select" name="active">
              <option value="1" <?= $active==='1'?'selected':'' ?>>Active</option>
              <option value="0" <?= $active==='0'?'selected':'' ?>>Inactive</option>
              <option value="all" <?= $active==='all'?'selected':'' ?>>All</option>
            </select>
          </div>
          <div class="col-6 col-md-2">
            <button class="btn btn-primary w-100" type="submit">Filter</button>
          </div>
          <div class="col-12 col-md-2">
            <a class="btn btn-outline-secondary w-100" href="/breakers/admin/list.php">Clear</a>
          </div>
        </form>
        <div class="small text-muted mt-2">Showing up to 250 rows. Use Batch Import for bulk updates.</div>
      </div>
    </div>

    <div class="card shadow-sm">
      <div class="table-responsive">
        <table class="table table-sm table-hover align-middle mb-0">
          <thead class="table-light">
            <tr>
              <th>ID</th>
              <th>Bin</th>
              <th>Brand</th>
              <th>Amps</th>
              <th>Poles</th>
              <th>Safety</th>
              <th>Mount</th>
              <th>SKU</th>
              <th>Friendly</th>
              <th>Status</th>
              <th>Updated</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><?= (int)$r['id'] ?></td>
                <td><?= h($r['bin_number']) ?></td>
                <td><?= h($r['brand']) ?></td>
                <td><?= h($r['amperage']) ?></td>
                <td><?= h($r['poles']) ?></td>
                <td><?= h($r['safety_features']) ?></td>
                <td><?= h($r['mounting']) ?></td>
                <td><?= h($r['sku']) ?></td>
                <td><?= h($r['friendly_sku']) ?></td>
                <td><?= $r['is_active'] ? '<span class="badge text-bg-success">Active</span>' : '<span class="badge text-bg-secondary">Inactive</span>' ?></td>
                <td class="small text-muted"><?= h($r['updated_at']) ?></td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-primary" href="/breakers/admin/edit.php?id=<?= (int)$r['id'] ?>">Edit</a>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="12" class="text-center text-muted py-4">No rows.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</body>
</html>
