<?php
declare(strict_types=1);
require_once __DIR__ . '/../inc/auth.php';
require_once __DIR__ . '/../inc/util.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = trim((string)($_POST['username'] ?? ''));
  $p = trim((string)($_POST['password'] ?? ''));
  if ($u === ADMIN_USER && $p === ADMIN_PASS) {
    $_SESSION['is_admin'] = 1;
    csrf_token(); // ensure token exists
    header('Location: /breakers/admin/list.php');
    exit;
  }
  $error = 'Invalid username or password.';
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container py-5" style="max-width:460px">
    <div class="card shadow-sm">
      <div class="card-body">
        <h1 class="h4 mb-3">Breaker Admin</h1>
        <?php if ($error): ?>
          <div class="alert alert-danger"><?= h($error) ?></div>
        <?php endif; ?>
        <form method="post" autocomplete="off">
          <div class="mb-2">
            <label class="form-label">Username</label>
            <input class="form-control" name="username" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Password</label>
            <input class="form-control" type="password" name="password" required>
          </div>
          <button class="btn btn-primary w-100" type="submit">Log in</button>
        </form>
        <div class="small text-muted mt-3">Tip: You can also protect /breakers/admin with cPanel “Directory Privacy”.</div>
      </div>
    </div>
    <div class="text-center mt-3">
      <a href="/breakers/" class="text-decoration-none">← Back to tool</a>
    </div>
  </div>
</body>
</html>
