<?php
declare(strict_types=1);
require_once __DIR__ . '/../inc/auth.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/util.php';
require_admin();

$row = ['is_active' => 1];
$error = '';

function save_upload(?array $file): ?string {
  if (!$file || empty($file['tmp_name']) || !is_uploaded_file($file['tmp_name'])) return null;
  $name = basename((string)$file['name']);
  $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
  if (!in_array($ext, ['png','jpg','jpeg','webp','gif'], true)) return null;

  $safeBase = preg_replace('/[^a-zA-Z0-9_\-\.]+/', '_', pathinfo($name, PATHINFO_FILENAME));
  $final = $safeBase . '_' . date('Ymd_His') . '.' . $ext;

  $destRel = 'uploads/' . $final;
  $destAbs = realpath(__DIR__ . '/..') . '/' . $destRel;

  if (@move_uploaded_file($file['tmp_name'], $destAbs)) return $destRel;
  return null;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_check((string)($_POST['csrf'] ?? ''))) {
    http_response_code(400);
    die('Bad CSRF token');
  }

  $row = [
    'bin_number' => q($_POST['bin_number'] ?? ''),
    'sku' => q($_POST['sku'] ?? '') ?: null,
    'friendly_sku' => q($_POST['friendly_sku'] ?? '') ?: null,
    'brand' => q($_POST['brand'] ?? ''),
    'amperage' => q($_POST['amperage'] ?? '') ?: null,
    'poles' => q($_POST['poles'] ?? '') ?: null,
    'safety_features' => q($_POST['safety_features'] ?? '') ?: null,
    'mounting' => q($_POST['mounting'] ?? '') ?: null,
    'product_link' => q($_POST['product_link'] ?? '') ?: null,
    'image_path' => q($_POST['image_path'] ?? '') ?: null,
    'is_active' => (int)($_POST['is_active'] ?? 1),
  ];

  $up = save_upload($_FILES['image_upload'] ?? null);
  if ($up) $row['image_path'] = $up;

  if ($row['bin_number'] === '' || $row['brand'] === '') {
    $error = 'Bin Number and Brand are required.';
  } else {
    $sql = "INSERT INTO breakers (bin_number, sku, friendly_sku, brand, amperage, poles, safety_features, mounting, image_path, product_link, is_active)
            VALUES (:bin, :sku, :fsku, :brand, :amp, :poles, :safety, :mount, :img, :link, :active)";
    $st = db()->prepare($sql);
    $st->execute([
      ':bin' => $row['bin_number'],
      ':sku' => $row['sku'],
      ':fsku' => $row['friendly_sku'],
      ':brand' => $row['brand'],
      ':amp' => $row['amperage'],
      ':poles' => $row['poles'],
      ':safety' => $row['safety_features'],
      ':mount' => $row['mounting'],
      ':img' => $row['image_path'],
      ':link' => $row['product_link'],
      ':active' => $row['is_active'] ? 1 : 0,
    ]);
    header('Location: /breakers/admin/list.php');
    exit;
  }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Add Breaker</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container py-4" style="max-width: 1000px;">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h1 class="h4 m-0">Add Breaker</h1>
      <a class="btn btn-outline-secondary btn-sm" href="/breakers/admin/list.php">Back</a>
    </div>

    <?php if ($error): ?>
      <div class="alert alert-danger"><?= h($error) ?></div>
    <?php endif; ?>

    <form class="card shadow-sm" method="post" enctype="multipart/form-data">
      <div class="card-body">
        <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
        <?php $isNew = true; include __DIR__ . '/_form.php'; ?>
      </div>
      <div class="card-footer d-flex justify-content-end gap-2">
        <button class="btn btn-primary" type="submit">Save</button>
      </div>
    </form>
  </div>
</body>
</html>
