<?php
declare(strict_types=1);

require_once __DIR__ . '/../inc/db.php';

header('Content-Type: application/json; charset=utf-8');

$pdo = db();

// Optionally pass current selections to keep options relevant
$brand   = trim((string)($_GET['brand'] ?? ''));
$amp     = trim((string)($_GET['amperage'] ?? ''));
$poles   = trim((string)($_GET['poles'] ?? ''));
$safety  = trim((string)($_GET['safety_features'] ?? ''));
$mount   = trim((string)($_GET['mounting'] ?? ''));

function distinct(PDO $pdo, string $col, array $whereCols): array {
  $conds = ["is_active = 1", "$col IS NOT NULL", "$col <> ''"];
  $params = [];
  foreach ($whereCols as $k => $v) {
    if ($v === '') continue;
    $conds[] = "$k = :$k";
    $params[":$k"] = $v;
  }
  $sql = "SELECT DISTINCT $col AS v FROM breakers WHERE " . implode(" AND ", $conds) . " ORDER BY v ASC";
  $st = $pdo->prepare($sql);
  $st->execute($params);
  return array_values(array_map(fn($r) => $r['v'], $st->fetchAll()));
}

$where = [
  'brand' => $brand,
  'amperage' => $amp,
  'poles' => $poles,
  'safety_features' => $safety,
  'mounting' => $mount,
];

echo json_encode([
  'ok' => true,
  'brands' => distinct($pdo, 'brand', array_diff_key($where, ['brand'=>1])),
  'amperages' => distinct($pdo, 'amperage', array_diff_key($where, ['amperage'=>1])),
  'poles' => distinct($pdo, 'poles', array_diff_key($where, ['poles'=>1])),
  'safety_features' => distinct($pdo, 'safety_features', array_diff_key($where, ['safety_features'=>1])),
  'mountings' => distinct($pdo, 'mounting', array_diff_key($where, ['mounting'=>1])),
]);
