<?php
declare(strict_types=1);

require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/util.php';

header('Content-Type: application/json; charset=utf-8');

$brand   = q($_GET['brand'] ?? '');
$amp     = q($_GET['amperage'] ?? '');
$poles   = q($_GET['poles'] ?? '');
$safety  = q($_GET['safety_features'] ?? '');
$mount   = q($_GET['mounting'] ?? '');
$qtext   = q($_GET['q'] ?? '');

$conds = ["is_active = 1"];
$params = [];

if ($brand !== '')  { $conds[] = "brand = :brand"; $params[':brand'] = $brand; }
if ($amp !== '')    { $conds[] = "amperage = :amp"; $params[':amp'] = $amp; }
if ($poles !== '')  { $conds[] = "poles = :poles"; $params[':poles'] = $poles; }
if ($safety !== '') { $conds[] = "safety_features = :safety"; $params[':safety'] = $safety; }
if ($mount !== '')  { $conds[] = "mounting = :mount"; $params[':mount'] = $mount; }

if ($qtext !== '') {
  $conds[] = "(sku LIKE :q OR friendly_sku LIKE :q OR product_link LIKE :q OR brand LIKE :q)";
  $params[':q'] = '%' . $qtext . '%';
}

$sql = "SELECT id, bin_number, sku, friendly_sku, brand, amperage, poles, safety_features, mounting, image_path, product_link
        FROM breakers
        WHERE " . implode(" AND ", $conds) . "
        ORDER BY brand ASC, amperage+0 ASC, poles ASC, safety_features ASC, bin_number+0 ASC
        LIMIT 200";

$stmt = db()->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

echo json_encode([
  'ok' => true,
  'count' => count($rows),
  'rows' => $rows,
]);
