<?php
declare(strict_types=1);

if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}

/**
 * Simple admin login.
 * Change ADMIN_USER + ADMIN_PASS (or use cPanel Directory Privacy too).
 */
const ADMIN_USER = 'admin';
const ADMIN_PASS = 'change-me-please';

function is_admin(): bool {
  return !empty($_SESSION['is_admin']);
}

function require_admin(): void {
  if (!is_admin()) {
    header('Location: /breakers/admin/login.php');
    exit;
  }
}

function csrf_token(): string {
  if (empty($_SESSION['csrf'])) {
    $_SESSION['csrf'] = bin2hex(random_bytes(16));
  }
  return (string)$_SESSION['csrf'];
}

function csrf_check(string $token): bool {
  return hash_equals((string)($_SESSION['csrf'] ?? ''), $token);
}
