<?php
declare(strict_types=1);

function h(?string $s): string {
  return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
}

function q(?string $s): string {
  return trim((string)$s);
}

function build_url(string $path): string {
  // App is installed under /breakers
  return '/breakers/' . ltrim($path, '/');
}
