-- Breakers Cross Reference Tool (MySQL)
-- Create the table in your cPanel database (phpMyAdmin -> SQL)

CREATE TABLE IF NOT EXISTS breakers (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
  bin_number VARCHAR(20) NOT NULL,
  sku VARCHAR(50) NULL,
  friendly_sku VARCHAR(50) NULL,
  brand VARCHAR(100) NOT NULL,
  amperage VARCHAR(20) NULL,
  poles VARCHAR(50) NULL,
  safety_features VARCHAR(100) NULL,
  mounting VARCHAR(100) NULL,
  image_path VARCHAR(255) NULL,
  product_link VARCHAR(512) NULL,
  is_active TINYINT(1) NOT NULL DEFAULT 1,

  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

  UNIQUE KEY uniq_sku (sku),
  KEY idx_brand (brand),
  KEY idx_amp (amperage),
  KEY idx_poles (poles),
  KEY idx_safety (safety_features),
  KEY idx_active (is_active)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
